<?php
//Payment IPN
Route::get('/ipnbtc', 'PaymentController@ipnBchain')->name('ipn.bchain');
Route::get('/ipnblockbtc', 'PaymentController@blockIpnBtc')->name('ipn.block.btc');
Route::get('/ipnblocklite', 'PaymentController@blockIpnLite')->name('ipn.block.lite');
Route::get('/ipnblockdog', 'PaymentController@blockIpnDog')->name('ipn.block.dog');
Route::post('/ipnpaypal', 'PaymentController@ipnpaypal')->name('ipn.paypal');
Route::post('/ipnperfect', 'PaymentController@ipnperfect')->name('ipn.perfect');
Route::post('/ipnstripe', 'PaymentController@ipnstripe')->name('ipn.stripe');
Route::post('/ipnskrill', 'PaymentController@skrillIPN')->name('ipn.skrill');
Route::post('/ipncoinpaybtc', 'PaymentController@ipnCoinPayBtc')->name('ipn.coinPay.btc');
Route::post('/ipncoinpayeth', 'PaymentController@ipnCoinPayEth')->name('ipn.coinPay.eth');
Route::post('/ipncoinpaybch', 'PaymentController@ipnCoinPayBch')->name('ipn.coinPay.bch');
Route::post('/ipncoinpaydash', 'PaymentController@ipnCoinPayDash')->name('ipn.coinPay.dash');
Route::post('/ipncoinpaydoge', 'PaymentController@ipnCoinPayDoge')->name('ipn.coinPay.doge');
Route::post('/ipncoinpayltc', 'PaymentController@ipnCoinPayLtc')->name('ipn.coinPay.ltc');
Route::post('/ipncoin', 'PaymentController@ipnCoin')->name('ipn.coinpay');
Route::post('/ipncoingate', 'PaymentController@ipnCoinGate')->name('ipn.coingate');

Route::post('/ipnpaytm', 'PaymentController@ipnPayTm')->name('ipn.paytm');
Route::post('/ipnpayeer', 'PaymentController@ipnPayEer')->name('ipn.payeer');
Route::post('/ipnpaystack', 'PaymentController@ipnPayStack')->name('ipn.paystack');
Route::post('/ipnvoguepay', 'PaymentController@ipnVoguePay')->name('ipn.voguepay');
//Payment IPN


/*
 * Frontend Manage
 */

Route::get('/', 'FrontendController@index')->name('homepage');
Route::get('/pending-orders', 'FrontendController@pendingOrders')->name('pending-orders');
Route::get('/completed-exchange', 'FrontendController@completedExchanges')->name('completed-exchange');

Route::get('/blog', 'FrontendController@blog')->name('blog');
Route::get('/blog-category/{id}/{slug}', 'FrontendController@categoryByBlog')->name('cats.blog');
Route::get('/details/{id}/{slug}', 'FrontendController@details')->name('blog.details');

Route::get('/about-us', 'FrontendController@about')->name('about');
Route::get('/faqs', 'FrontendController@faqs')->name('faqs');
Route::get('/click-add/{id}', 'FrontendController@clickadd');
Route::get('/contact-us', 'FrontendController@contactUs')->name('contact');
Route::post('/contact-us', 'FrontendController@contactSubmit')->name('contact.submit');


Route::post('/subscribe', 'FrontendController@subscribe')->name('subscribe');
Route::get('/change-lang/{lang}', 'FrontendController@changeLang')->name('lang');
Route::post('/g2fa-verify', 'FrontendController@verify2fa')->name('go2fa.verify');

Route::post('checkMail','FrontendController@checkMail')->name('checkMail');
Route::post('checkUsername','FrontendController@checkUsername')->name('checkUsername');
Route::get('/get/rate','FrontendController@ajaxGetRate')->name('get.rate');
Route::get('/get/withdraw','FrontendController@ajaxGetWithdraw')->name('get.withdrawRate');

Auth::routes();

Route::group(['middleware' => ['guest']], function () {
    Route::get('/register/{reference}', 'FrontendController@register')->name('refer.register');
});


Route::group(['prefix' => 'user'], function () {

    Route::get('authorization', 'HomeController@authCheck')->name('user.authorization');

    Route::post('verification', 'HomeController@sendVcode')->name('user.send-vcode');
    Route::post('smsVerify', 'HomeController@smsVerify')->name('user.sms-verify');

    Route::post('verify-email', 'HomeController@sendEmailVcode')->name('user.send-emailVcode');
    Route::post('postEmailVerify', 'HomeController@postEmailVerify')->name('user.email-verify');


    Route::group(['middleware' => ['auth', 'CheckStatus']], function () {

        Route::get('/vogue/{trx}/{type}', 'PaymentController@purchaseVogue')->name('vogue');

        Route::post('exchange','HomeController@exchange')->name('user.exchange');
        Route::get('exchange/preview','HomeController@exchangePreview')->name('preview.info');
        Route::post('exchange/preview','HomeController@exchangePreviewOk')->name('preview.info.ok');
        Route::get('exchange/confirm','HomeController@exchangeConfirm')->name('exchange-confirm');
        Route::post('exchange/confirm','HomeController@exchangeConfirmOk')->name('exchange-confirm.ok');

        Route::get('/home', 'HomeController@index')->name('home');
        Route::get('/exchange/details/{trx}', 'HomeController@exchangeDetails')->name('exchange.details');
    /*
     * Deposit
     */
        Route::any('/deposit', 'HomeController@deposit')->name('deposit');
        Route::post('/deposit-data-insert', 'HomeController@depositDataInsert')->name('deposit.data-insert');
        Route::get('/deposit-preview', 'HomeController@depositPreview')->name('user.deposit.preview');
        Route::post('/deposit-confirm', 'PaymentController@depositConfirm')->name('deposit.confirm');

    /*
     *  Withdraw
     */
        Route::get('/withdraw', 'HomeController@withdrawMoney')->name('withdraw.money');
        Route::post('/withdraw', 'HomeController@withdrawRequest')->name('withdraw.request');

        Route::get('withdraw/confirm','HomeController@withdrawPreview')->name('withdraw.preview.info');
        Route::post('withdraw/confirm','HomeController@withdrawConfirm')->name('withdraw.confirm');



        Route::get('/transactions', 'HomeController@activity')->name('user.trx');
        Route::get('/deposit-log', 'HomeController@depositLog')->name('user.depositLog');
        Route::get('/withdraw-log', 'HomeController@withdrawLog')->name('user.withdrawLog');

        Route::get('change-password', 'HomeController@changePassword')->name('user.change-password');
        Route::post('change-password', 'HomeController@submitPassword')->name('user.change-password');

        Route::get('my-profile', 'HomeController@editProfile')->name('edit-profile');
        Route::post('my-profile', 'HomeController@submitProfile')->name('edit-profile');


        Route::get('reference-bonus','HomeController@referenceBonus')->name('reference-bonus');

    });
});




Route::group(['prefix' => 'admin'], function () {
    Route::get('/', 'AdminLoginController@index')->name('admin.loginForm');
    Route::post('/', 'AdminLoginController@authenticate')->name('admin.login');
});


Route::group(['prefix' => 'admin', 'middleware' => 'auth:admin'], function () {


    Route::get('/dashboard', 'AdminController@dashboard')->name('admin.dashboard');

    //refer
    Route::get('/referral', 'AdminController@refIndex')->name('referral.index');
    Route::post('/referral', 'AdminController@refStore')->name('store.refer');


    Route::resource('/currency', 'CurrencyController');


    //withdraw
    Route::get('/exchange/requests', 'DashboardController@exchange')->name('exchange.requests');
    Route::get('/exchange/approved', 'DashboardController@exchangeApprove')->name('exchange.approved');
    Route::get('/exchange/cancel', 'DashboardController@exchangeCancel')->name('exchange.cancel');
    Route::get('/exchange/refund', 'DashboardController@exchangeRefund')->name('exchange.refund');
    Route::get('/exchange/info/{id}', 'DashboardController@exchangeDetails')->name('admin.exchange.info');

    Route::post('/exchange/cancel', 'DashboardController@cancelExchange')->name('cancel.exchange');
    Route::post('/exchange/success', 'DashboardController@successExchange')->name('success.exchange');
    Route::post('/exchange/refund', 'DashboardController@refundExchange')->name('refund.exchange');


    // Blog Controller
    Route::get('/post-category', 'PostController@category')->name('admin.cat');
    Route::post('/post-category', 'PostController@UpdateCategory')->name('update.cat');
    Route::get('blog', 'PostController@index')->name('admin.blog');
    Route::get('blog/create', 'PostController@create')->name('blog.create');
    Route::post('blog/create', 'PostController@store')->name('blog.store');
    Route::delete('blog/delete', 'PostController@destroy')->name('blog.delete');
    Route::get('blog/edit/{id}', 'PostController@edit')->name('blog.edit');
    Route::post('blog-update', 'PostController@updatePost')->name('blog.update');



    //Gateway
    Route::get('/gateway', 'GatewayController@show')->name('gateway');
    Route::get('/gateway/{id}', 'GatewayController@edit')->name('gateway.edit');
    Route::post('/gateway', 'GatewayController@update')->name('update.gateway');

    //Deposit
    Route::get('/deposits', 'DepositController@index')->name('deposits');
    Route::get('/deposits/requests', 'DepositController@requests')->name('deposits.requests');
    Route::put('/deposit/approve/{id}', 'DepositController@approve')->name('deposit.approve');
    Route::get('/deposit/{deposit}/delete', 'DepositController@destroy')->name('deposit.destroy');

    //withdraw
    Route::get('/withdraw/requests', 'WithdrawController@requests')->name('withdraw.requests');
    Route::get('/withdraw/approved', 'WithdrawController@requestsApprove')->name('withdraw.approved');
    Route::get('/withdraw/refunded', 'WithdrawController@requestsRefunded')->name('withdraw.refunded');

    Route::put('/withdraw/approve/{id}', 'WithdrawController@approve')->name('withdraw.approve');
    Route::post('/withdraw/refund', 'WithdrawController@refundAmount')->name('withdraw.refund');


    //Email Template
    Route::get('/template', 'EtemplateController@index')->name('email.template');
    Route::post('/template-update', 'EtemplateController@update')->name('template.update');
    //Sms Api
    Route::get('/sms-api', 'EtemplateController@smsApi')->name('sms.api');
    Route::post('/sms-update', 'EtemplateController@smsUpdate')->name('sms.update');


    // General Settings
    Route::get('/general-settings', 'GeneralSettingController@GenSetting')->name('admin.GenSetting');
    Route::post('/general-settings', 'GeneralSettingController@UpdateGenSetting')->name('admin.UpdateGenSetting');
    Route::get('/change-password', 'GeneralSettingController@changePassword')->name('admin.changePass');
    Route::post('/change-password', 'GeneralSettingController@updatePassword')->name('admin.changePass');
    Route::get('/profile', 'GeneralSettingController@profile')->name('admin.profile');
    Route::post('/profile', 'GeneralSettingController@updateProfile')->name('admin.profile');


    //User Management
    Route::get('users', 'GeneralSettingController@users')->name('users');
    Route::get('user-search', 'GeneralSettingController@userSearch')->name('search.users');
    Route::get('user/{user}', 'GeneralSettingController@singleUser')->name('user.single');
    Route::put('user/pass-change/{user}', 'GeneralSettingController@userPasschange')->name('user.passchange');
    Route::put('user/status/{user}', 'GeneralSettingController@statupdate')->name('user.status');
    Route::get('mail/{user}', 'GeneralSettingController@userEmail')->name('user.email');
    Route::post('/sendmail', 'GeneralSettingController@sendemail')->name('send.email');
    Route::get('/user-login-history/{id}', 'GeneralSettingController@loginLogsByUsers')->name('user.login.history');



    Route::get('/user-banned', 'GeneralSettingController@banusers')->name('user.ban');
    Route::get('login-logs/{user?}', 'GeneralSettingController@loginLogs')->name('user.login-logs');
    Route::get('/user-transaction/{id}', 'GeneralSettingController@userTrans')->name('user.trans');
    Route::get('/user-deposit/{id}', 'GeneralSettingController@userDeposit')->name('user.deposit');
    Route::get('/user-withdraw/{id}', 'GeneralSettingController@userWithdraw')->name('user.withdraw');


    //Contact Setting
    Route::get('contact-setting', 'WebSettingController@getContact')->name('contact-setting');
    Route::put('contact-setting/{id}', 'WebSettingController@putContactSetting')->name('contact-setting-update');

    Route::get('manage-logo', 'WebSettingController@manageLogo')->name('manage-logo');
    Route::post('manage-logo', 'WebSettingController@updateLogo');

    Route::get('manage-text', 'WebSettingController@manageFooter')->name('manage-footer');
    Route::put('manage-text', 'WebSettingController@updateFooter')->name('manage-footer-update');

    Route::get('manage-breadcrumb', 'WebSettingController@mangeBreadcrumb')->name('mange-breadcrumb');
    Route::post('manage-breadcrumb', 'WebSettingController@updateBreadcrumb');


    Route::get('manage-social', 'WebSettingController@manageSocial')->name('manage-social');
    Route::post('manage-social', 'WebSettingController@storeSocial')->name('manage-social');
    Route::get('manage-social/{product_id?}', 'WebSettingController@editSocial')->name('social-edit');
    Route::put('manage-social/{product_id?}', 'WebSettingController@updateSocial')->name('social-edit');
    Route::post('delete-social', 'WebSettingController@destroySocial')->name('del.social');


    Route::get('manage-about', 'WebSettingController@manageAbout')->name('manage-about');
    Route::post('manage-about', 'WebSettingController@updateAbout')->name('manage-about');

    Route::get('manage-privacy', 'WebSettingController@managePrivacy')->name('manage-privacy');
    Route::post('manage-privacy', 'WebSettingController@updatePrivacy')->name('manage-privacy');

    Route::get('manage-terms', 'WebSettingController@manageTerms')->name('manage-terms');
    Route::post('manage-terms', 'WebSettingController@updateTerms')->name('manage-terms');

    Route::get('faqs-create', 'WebSettingController@createFaqs')->name('faqs-create');
    Route::post('faqs-create', 'WebSettingController@storeFaqs')->name('faqs-create');
    Route::get('faqs-all', 'WebSettingController@allFaqs')->name('faqs-all');
    Route::get('faqs-edit/{id}', 'WebSettingController@editFaqs')->name('faqs-edit');
    Route::put('faqs-edit/{id}', 'WebSettingController@updateFaqs')->name('faqs-update');
    Route::delete('faqs-delete', 'WebSettingController@deleteFaqs')->name('faqs-delete');


    /*
     * Subscriber
     */

    Route::get('/subscribers', 'DashboardController@manageSubscribers')->name('manage.subscribers');
    Route::post('/update-subscribers', 'DashboardController@updateSubscriber')->name('update.subscriber');
    Route::get('/send-email', 'DashboardController@sendMail')->name('send.mail.subscriber');
    Route::post('/send-email', 'DashboardController@sendMailsubscriber')->name('send.email.subscriber');


    /*
     * Our Event
     */
    Route::get('our-event', 'OurEventController@index')->name('our.event');
    Route::post('our-event', 'OurEventController@store')->name('store.event');
    Route::delete('our-event', 'OurEventController@delete')->name('delete.event');
    /*
     * Our Team Controller
     */
    Route::get('our-team', 'OurTeamController@ourTeam')->name('team');
    Route::get('our-team/create', 'OurTeamController@createOurTeam')->name('create.team');
    Route::post('our-team/create', 'OurTeamController@storeOurTeam')->name('store.team');
    Route::get('our-team/{id}', 'OurTeamController@editOurTeam')->name('edit.team');
    Route::post('our-team/{id}', 'OurTeamController@updateOurTeam')->name('update.team');
    Route::delete('our-team', 'OurTeamController@deleteOurTeam')->name('delete.team');


    /*
     * Testimonial Controller
     */
    Route::get('testimonial', 'TestimonialController@index')->name('admin.testimonial');
    Route::get('testimonial/create', 'TestimonialController@create')->name('testimonial.create');
    Route::post('testimonial/create', 'TestimonialController@store')->name('testimonial.store');
    Route::delete('testimonial/delete', 'TestimonialController@destroy')->name('testimonial.delete');
    Route::get('testimonial/edit/{id}', 'TestimonialController@edit')->name('testimonial.edit');
    Route::post('testimonial-update', 'TestimonialController@updatePost')->name('testimonial.update');



    /*
     * Language Controller
     */
    Route::get('/language/manager', 'LanguageController@langManage')->name('language-manage');
    Route::post('/language/manager', 'LanguageController@langStore')->name('language-manage-store');
    Route::delete('language-manage/{id}', 'LanguageController@langDel')->name('language-manage-del');
    Route::get('language-key/{id}', 'LanguageController@langEdit')->name('language-key');
    Route::put('key-update/{id}', 'LanguageController@langUpdate')->name('key-update');
    Route::post('language-manage-update/{id}', 'LanguageController@langUpdatepp')->name('language-manage-update');

    Route::post('language-import}', 'LanguageController@langImport')->name('import_lang');


    Route::get('/logout', 'AdminController@logout')->name('admin.logout');
});



/*============== User Password Reset Route list ===========================*/
Route::get('user-password/reset', 'User\ForgotPasswordController@showLinkRequestForm')->name('user.password.request');
Route::post('user-password/email', 'User\ForgotPasswordController@sendResetLinkEmail')->name('user.password.email');
Route::get('user-password/reset/{token}', 'User\ResetPasswordController@showResetForm')->name('user.password.reset');
Route::post('user-password/reset', 'User\ResetPasswordController@reset');






